/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.snuffles.common.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import mod.schnappdragon.snuffles.core.registry.SnufflesBlocks;
import mod.schnappdragon.snuffles.core.registry.SnufflesEntityTypes;
import mod.schnappdragon.snuffles.core.registry.SnufflesParticleTypes;
import mod.schnappdragon.snuffles.core.registry.SnufflesSoundEvents;
import mod.schnappdragon.snuffles.core.tags.SnufflesBlockTags;
import mod.schnappdragon.snuffles.core.tags.SnufflesItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Snuffle
extends Animal
implements IForgeShearable {
    private static final EntityDataAccessor<Integer> FROST_COUNTER = SynchedEntityData.m_135353_(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_HAIRSTYLE_ID = SynchedEntityData.m_135353_(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_FLUFF = SynchedEntityData.m_135353_(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_FROSTY = SynchedEntityData.m_135353_(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LICKING = SynchedEntityData.m_135353_(Snuffle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int fluffGrowTime = 18000 + this.m_21187_().nextInt(6000);

    public Snuffle(EntityType<Snuffle> snuffle, Level world) {
        super(snuffle, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SnuffleTemptGoal(1.1, Ingredient.m_204132_(SnufflesItemTags.SNUFFLE_FOOD), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new FrostGoal());
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROST_COUNTER, (Object)0);
        this.f_19804_.m_135372_(DATA_HAIRSTYLE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLUFF, (Object)false);
        this.f_19804_.m_135372_(DATA_FROSTY, (Object)false);
        this.f_19804_.m_135372_(IS_LICKING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Hairstyle", this.getHairstyleId());
        compound.m_128379_("HasFluff", this.hasFluff());
        compound.m_128379_("Frosty", this.isFrosty());
        compound.m_128405_("FluffGrowTime", this.fluffGrowTime);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHairstyleId(compound.m_128451_("Hairstyle"));
        this.setFluff(compound.m_128471_("HasFluff"));
        this.setFrosty(compound.m_128471_("Frosty"));
        this.fluffGrowTime = compound.m_128451_("FluffGrowTime");
    }

    public void setFrostCounter(int counter) {
        this.f_19804_.m_135381_(FROST_COUNTER, (Object)counter);
    }

    public int getFrostCounter() {
        return (Integer)this.f_19804_.m_135370_(FROST_COUNTER);
    }

    public boolean isFrosting() {
        return this.getFrostCounter() > 0;
    }

    public void setHairstyleId(int id) {
        this.f_19804_.m_135381_(DATA_HAIRSTYLE_ID, (Object)id);
    }

    public int getHairstyleId() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(DATA_HAIRSTYLE_ID)), (int)0, (int)3);
    }

    public Hairstyle getHairstyle() {
        return Hairstyle.getHairstyleById(this.getHairstyleId());
    }

    public void setFluff(boolean hasFluff) {
        this.f_19804_.m_135381_(DATA_FLUFF, (Object)hasFluff);
    }

    public boolean hasFluff() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FLUFF);
    }

    public void setFrosty(boolean isFrosty) {
        this.f_19804_.m_135381_(DATA_FROSTY, (Object)isFrosty);
    }

    public boolean isFrosty() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FROSTY);
    }

    public void setLicking(boolean isLicking) {
        this.f_19804_.m_135381_(IS_LICKING, (Object)isLicking);
    }

    public boolean isLicking() {
        return (Boolean)this.f_19804_.m_135370_(IS_LICKING);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isFrosty()) {
            if (this.m_6060_()) {
                this.m_20095_();
                this.setFrosty(false);
                this.m_146873_();
            }
            if ((this.f_19790_ != this.m_20185_() || this.f_19791_ != this.m_20186_() || this.f_19792_ != this.m_20189_()) && this.m_21187_().nextBoolean()) {
                this.f_19853_.m_7106_((ParticleOptions)SnufflesParticleTypes.SNOWFLAKE.get(), this.m_20208_(0.4), this.m_20187_(), this.m_20262_(0.4), 0.0, 0.0, 0.0);
            }
        }
        if (!this.hasFluff() && !this.m_6162_()) {
            if (this.fluffGrowTime > 0) {
                --this.fluffGrowTime;
            } else {
                this.setFluff(true);
            }
        }
    }

    private boolean isSnowingAt(Level world, BlockPos pos) {
        if (!world.m_46471_()) {
            return false;
        }
        if (!world.m_45527_(pos)) {
            return false;
        }
        if (world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return false;
        }
        return ((Biome)world.m_204166_(pos).m_203334_()).m_198904_(pos);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42518_)) {
            if (!this.f_19853_.f_46443_) {
                this.m_142075_(player, hand, stack);
                this.setHairstyleId((this.getHairstyleId() + 1) % 4);
                this.m_5496_((SoundEvent)SnufflesSoundEvents.SNUFFLE_STYLE.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (stack.m_150930_(Items.f_42542_) && this.isFrosty()) {
            if (!this.f_19853_.f_46443_) {
                this.setFrosty(false);
                this.m_142075_(player, hand, stack);
                this.m_5496_((SoundEvent)SnufflesSoundEvents.SNUFFLE_THAW.get(), 0.7f, 1.6f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (this.m_6898_(stack)) {
            this.m_5496_((SoundEvent)SnufflesSoundEvents.SNUFFLE_EAT.get(), 1.0f, 1.0f);
        }
        super.m_142075_(player, hand, stack);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SnufflesSoundEvents.SNUFFLE_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SnufflesSoundEvents.SNUFFLE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SnufflesSoundEvents.SNUFFLE_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SnufflesSoundEvents.SNUFFLE_STEP.get(), 0.15f, 1.0f);
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)SnufflesParticleTypes.SNOWFLAKE.get(), this.m_20208_(0.8), this.m_20188_(), this.m_20262_(0.8), 0.0, 0.1, 0.0);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean isShearable(@NotNull ItemStack item, Level world, BlockPos pos) {
        return this.m_6084_() && !this.m_6162_() && this.hasFluff();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        this.setFluff(false);
        this.f_19853_.m_142346_((Entity)player, GameEvent.f_157781_, pos);
        this.fluffGrowTime = 18000 + this.m_21187_().nextInt(6000);
        this.m_5496_((SoundEvent)SnufflesSoundEvents.SNUFFLE_SHEAR.get(), 1.0f, 1.0f);
        return List.of(new ItemStack(this.isFrosty() ? (ItemLike)SnufflesBlocks.FROSTY_FLUFF.get() : (ItemLike)SnufflesBlocks.SNUFFLE_FLUFF.get()));
    }

    public static boolean checkSnuffleSpawnRules(EntityType<Snuffle> snuffle, LevelAccessor world, MobSpawnType spawnType, BlockPos pos, Random random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(SnufflesBlockTags.SNUFFLES_SPAWNABLE_ON) && Snuffle.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compound) {
        boolean frosty = ((Biome)world.m_204166_(this.m_142538_()).m_203334_()).m_198904_(this.m_142538_());
        if (groupData instanceof SnuffleGroupData) {
            frosty = ((SnuffleGroupData)((Object)groupData)).frosty;
        } else {
            groupData = new SnuffleGroupData(frosty);
        }
        SnuffleGroupData snuffleGroupData = (SnuffleGroupData)((Object)groupData);
        if (snuffleGroupData.m_146777_() > 0 && this.f_19796_.nextFloat() <= snuffleGroupData.m_146780_()) {
            this.m_146762_(-24000);
        } else {
            this.setFluff(true);
        }
        this.setFrosty(frosty);
        return super.m_6518_(world, difficulty, spawnType, groupData, compound);
    }

    @Nullable
    public Snuffle getBreedOffspring(ServerLevel world, AgeableMob snuffle) {
        return (Snuffle)((EntityType)SnufflesEntityTypes.SNUFFLE.get()).m_20615_((Level)world);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(SnufflesItemTags.SNUFFLE_FOOD);
    }

    public void m_6667_(DamageSource source) {
        this.setFrostCounter(0);
        super.m_6667_(source);
    }

    class SnuffleTemptGoal
    extends TemptGoal {
        public SnuffleTemptGoal(double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)Snuffle.this, speedModifier, items, canScare);
        }

        public void m_8056_() {
            super.m_8056_();
            Snuffle.this.setLicking(true);
        }

        public void m_8041_() {
            super.m_8041_();
            Snuffle.this.setLicking(false);
        }
    }

    class FrostGoal
    extends Goal {
        private static final int WAIT_TIME_BEFORE_FROST = FrostGoal.m_186073_((int)140);
        private int countdown;

        public FrostGoal() {
            this.countdown = Snuffle.this.f_19796_.nextInt(WAIT_TIME_BEFORE_FROST);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Snuffle.this.f_20900_ == 0.0f && Snuffle.this.f_20901_ == 0.0f && Snuffle.this.f_20902_ == 0.0f && this.canFrost();
        }

        public boolean m_8045_() {
            return Snuffle.this.isFrosting() && this.canFrost();
        }

        private boolean canFrost() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            Level world = Snuffle.this.f_19853_;
            BlockPos pos = Snuffle.this.m_142538_();
            return !Snuffle.this.isFrosty() && (Snuffle.this.isSnowingAt(world, pos) || world.m_8055_(pos).m_60713_(Blocks.f_152499_));
        }

        public void m_8037_() {
            Snuffle.this.setFrostCounter(Math.max(0, Snuffle.this.getFrostCounter() - 1));
            if (Snuffle.this.getFrostCounter() % this.m_183277_(4) == 0) {
                Snuffle.this.m_5496_((SoundEvent)SnufflesSoundEvents.SNUFFLE_SHAKE.get(), 1.0f, (Snuffle.this.f_19796_.nextFloat() - Snuffle.this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                Snuffle.this.setFrosty(Snuffle.this.getFrostCounter() == this.m_183277_(4));
                Snuffle.this.f_19853_.m_7605_((Entity)Snuffle.this, (byte)10);
            }
        }

        public void m_8056_() {
            Snuffle.this.setFrostCounter(this.m_183277_(40));
            Snuffle.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Snuffle.this.setFrostCounter(0);
            this.countdown = Snuffle.this.f_19796_.nextInt(WAIT_TIME_BEFORE_FROST);
        }
    }

    public static enum Hairstyle {
        DEFAULT,
        SHEEPDOG,
        PORO,
        HORSESHOE;

        private static final Hairstyle[] HAIRSTYLES;

        public static Hairstyle getHairstyleById(int id) {
            return HAIRSTYLES[id];
        }

        static {
            HAIRSTYLES = Hairstyle.values();
        }
    }

    public static class SnuffleGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final boolean frosty;

        public SnuffleGroupData(boolean frosty) {
            super(false);
            this.frosty = frosty;
        }
    }
}

